<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:template match="/">
		<html>
			<head>
				<title> NOTIFICATION OF REMOVAL FROM LISTING AND/OR REGISTRATION UNDER SECTION 12(b)
			  							OF THE SECURITIES EXCHANGE ACT OF 1934.
			  			</title>
				<style type="text/css">
				  	h3 {font-sytle: bold; font-size: 18; font-weight: bold;}
				  	h4 {font-style: normal; font-size: 17; font-weight: normal;}
					 
				  </style>
			</head>
			<body BGCOLOR="DCDCDC">
				<table align="center" width="650">
					<tr>
						<td align="center">
							<table align="center" width="500">
								<tr>
									<td align="center">UNITED STATES</td>
								</tr>
								<tr>
									<td align="center">SECURITIES AND EXCHANGE COMMISSION</td>
								</tr>
								<tr>
									<td align="center">Washington, D.C. 20549</td>
								</tr>
								<tr>
									<td align="center">
										<h3>FORM 25</h3>
									</td>
								</tr>
								<tr>
									<td align="center">
										<h3>NOTIFICATION OF REMOVAL FROM LISTING AND/OR REGISTRATION UNDER SECTION 12(b)
			  							OF THE SECURITIES EXCHANGE ACT OF 1934.
			  							</h3>
									</td>
								</tr>
							</table>
						</td>
					</tr>
					<tr>
						<td align="right">Commission File Number </td>
						<td>
							<u>
								<xsl:value-of select="notificationOfRemoval/issuer/fileNumber"/>
							</u>
						</td>
					</tr>
					<tr>
						<xsl:apply-templates select="notificationOfRemoval/issuer"/>
					</tr>
					<p/>
					<tr>
						<td>
							<table align="center" width="650">
								<tr>
									Please place an X in the box to designate the rule provision relied upon to strike
									the class of securities from listing and registration:
								</tr>
							</table>
						</td>
					</tr>
					<p/>
					<tr>
						<xsl:call-template name="ruleProvision"/>
					</tr>
					<p/>
					<tr>
						<td>
							<table align="center" width="650">
								<tr>
										Pursuant to the requirements for the Securities Exchange Act of 1934, 
										<u>
										<xsl:value-of select="notificationOfRemoval/exchange/entityName"/> 
										</u>
										certifies that it has reasonable grounds to believe that it
										meets all of the requirements for filing the Form 25 and has caused this notification to be
										signed on its behalf by the undersigned duly authorized person.
									</tr>
							</table>
						</td>
					</tr>
					<p/>
					<tr>
					
						<xsl:apply-templates select="notificationOfRemoval/signatureData"/>
					</tr>
					<br/>
					<tr>
						<table align="center" width="650">
							<tr>
								<td align="left" valign="top" width="40">
									<a name="Footnote1">
										<sup>1</sup>
									</a>
								</td>
								<td align="left">
									Form 25 and attached Notice will be considered compliance with the provisions of
									17 CFR 240.19d-1 as applicable. <a href="#">See</a> General Instructions.
									</td>
							</tr>
						</table>
					</tr>
				</table>
			</body>
		</html>
	</xsl:template>
	<xsl:template match="notificationOfRemoval/issuer">
		<table align="center" width="650">
			<tr>
				<td valign="bottom" align="center" style="border: solid black; border-top-width: 0;
	 							border-right-width: 0; border-bottom-width: 2; border-left-width: 0;">
				<table>
				<tr>
				<td valign="top">
					Issuer:
				</td>
				<td>
					 <xsl:value-of select="//notificationOfRemoval/issuer/entityName"/>
				</td>
				</tr>
				<tr>
				<td valign="top">
					Exchange:
				</td>
				<td>
					 <xsl:value-of select="//notificationOfRemoval/exchange/entityName"/>
				</td>	
				</tr>
				</table>
				</td>
			</tr>
			<tr>
				<td valign="top" align="center">
					<div style="font-size: 9pt;">
							(Exact name of Issuer as specified in its charter, and name of
							Exchange where security is listed and/or registered)
							</div>
				</td>
			</tr>
			<tr>
				<td valign="bottom" align="center" style="border: solid black; border-top-width: 0;
	 							border-right-width: 0; border-bottom-width: 2; border-left-width: 0;">
				<table>
					<tr>
						<td align="right" valign="top">
						Address: 
						</td>
						<td>
							<table>
								<tr>
									<td>
									<xsl:value-of select="./address/street1"/> 
									</td>
								</tr>
								<tr>
									<td align="left">
									<xsl:value-of select="./address/city"/>, 
									</td>
								</tr>
								<tr>
									<td align="left">
									<xsl:value-of select="./address/stateOrCountry"/> 
									</td>
								</tr>
								<tr>
									<td align="left">
									<xsl:value-of select="./address/zipCode"/>
									</td>
								</tr>
							</table>
						</td>
					</tr>
					<tr>
						<td align="right" valign="top">
						Telephone number: 
						</td>
						<td align="left">
						<xsl:value-of select="./telephoneNumber"/>
						</td>
					</tr>
				</table>
				</td>
			</tr>
			<tr>
				<td valign="top" align="center">
					<div style="font-size: 9pt;">
								(Address, including zip code, and telephone number, including area code, of Issuer's
								principal executive offices)
							</div>
				</td>
			</tr>
			<tr>
				<td valign="bottom" align="center" style="border: solid black; border-top-width: 0;
	 							border-right-width: 0; border-bottom-width: 2; border-left-width: 0;">
					<xsl:value-of select="//notificationOfRemoval/descriptionClassSecurity"/>
				</td>
			</tr>
			<tr>
				<td valign="top" align="center">
					<div style="font-size: 9pt;">
								(Description of class of securities)
							</div>
				</td>
			</tr>
		</table>
	</xsl:template>	
	<xsl:template name="ruleProvision">
		<table align="center" width="650" cellspacing="10">
			<tr>
				<td>
				<input type="checkbox" disabled="true">
					<xsl:for-each select="notificationOfRemoval/ruleProvision"><xsl:if test=".='17 CFR 240.12d2-2(a)(1)'">
						<xsl:attribute name="checked"/>
					</xsl:if></xsl:for-each>
				</input>
				<xsl:text>17 CFR 240.12d2-2(a)(1)</xsl:text>
				</td>
			</tr>
			<tr>
				<td>
				<input type="checkbox" disabled="true">
					<xsl:for-each select="notificationOfRemoval/ruleProvision"><xsl:if test=".='17 CFR 240.12d2-2(a)(2)'">
						<xsl:attribute name="checked"/>
					</xsl:if></xsl:for-each>
				</input>
				<xsl:text>17 CFR 240.12d2-2(a)(2)</xsl:text>
				</td>
			</tr>
			<tr>
				<td>
				<input type="checkbox" disabled="true">
					<xsl:for-each select="notificationOfRemoval/ruleProvision"><xsl:if test=".='17 CFR 240.12d2-2(a)(3)'">
						<xsl:attribute name="checked"/>
					</xsl:if></xsl:for-each>
				</input>
				<xsl:text>17 CFR 240.12d2-2(a)(3)</xsl:text>
				</td>
			</tr>
			<tr>
				<td>	
				<input type="checkbox" disabled="true">
					<xsl:for-each select="notificationOfRemoval/ruleProvision"><xsl:if test=".='17 CFR 240.12d2-2(a)(4)'">
						<xsl:attribute name="checked"/>
					</xsl:if></xsl:for-each>
				</input>
				<xsl:text>17 CFR 240.12d2-2(a)(4)</xsl:text>
				</td>
			</tr>
			<tr>
				<td>				
					<input type="checkbox"  disabled="true">
					<xsl:for-each select="notificationOfRemoval/ruleProvision"><xsl:if test=".='17 CFR 240.12d2-2(b)'">
						<xsl:attribute name="checked"/>
					</xsl:if></xsl:for-each>
					</input>
					Pursuant to 17 CFR 240.12d2-2(b), the Exchange has complied with its rules to	strike the class of securities from listing and/or withdraw registration on the Exchange.
					<a href="#Footnote1"><sup>1</sup></a>
				</td>
			</tr>
			<tr>
				<td>
					<input type="checkbox"  disabled="true" />						
					Pursuant to 17 CFR 240.12d2-2(c), the Issuer has complied with its rules of the Exchange and the requirements of 17 CFR 240.12d-2(c) governing the voluntary withdrawal of the class of securities from listing and registration on the Exchange.
				</td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template match="notificationOfRemoval/signatureData">
		<table align="center" width="650">
			<tr>
				<td valign="bottom" align="center" style="border: solid black; border-top-width: 0;
	 							border-right-width: 0; border-bottom-width: 1; border-left-width: 0;" cellpadding="10" cellspacing="0" width="120">
					<xsl:value-of select="./signatureDate"/>
				</td>
				<td align="right" width="50">By</td>
				<td valign="bottom" align="center" style="border: solid black; border-top-width: 0;
	 							border-right-width: 0; border-bottom-width: 1; border-left-width: 0;" cellpadding="0" cellspacing="5" width="200">
					<xsl:value-of select="./signatureName"/>
				</td>
				<td width="10"/>
				<td valign="bottom" align="center" style="border: solid black; border-top-width: 0;
	 							border-right-width: 0; border-bottom-width: 1; border-left-width: 0;" width="120">
					<xsl:value-of select="./signatureTitle"/>
				</td>
			</tr>
			<tr>
				<td align="center">
						Date
					</td>
				<td/>
				<td align="center" colspan="2">Name</td>
				<td align="center">Title</td>
			</tr>
		</table>
	</xsl:template>
</xsl:stylesheet>
